<?php
require_once 'config.php';
require_once 'otp_handler.php';

?>

<!DOCTYPE html>
<html>
<head>
    <title>Test Email Sending</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; }
        .test-container { background: #f5f5f5; padding: 20px; border-radius: 8px; }
        .test-item { margin: 15px 0; padding: 15px; background: white; border-left: 4px solid #ddd; }
        .success { border-left-color: #4CAF50; color: #4CAF50; }
        .error { border-left-color: #f44336; color: #f44336; }
        input { width: 100%; padding: 10px; margin: 10px 0; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        button { padding: 10px 20px; background: #4CAF50; color: white; border: none; border-radius: 4px; cursor: pointer; }
        button:hover { background: #45a049; }
    </style>
</head>
<body>
    <h1>Email Sending Test</h1>
    <div class="test-container">
        <h2>Test Email Configuration</h2>
        
        <div class="test-item">
            <strong>MAIL_HOST:</strong> <?php echo MAIL_HOST; ?>
        </div>
        
        <div class="test-item">
            <strong>MAIL_PORT:</strong> <?php echo MAIL_PORT; ?>
        </div>
        
        <div class="test-item">
            <strong>MAIL_USERNAME:</strong> <?php echo MAIL_USERNAME; ?>
        </div>
        
        <div class="test-item">
            <strong>OTP_LENGTH:</strong> <?php echo OTP_LENGTH; ?>
        </div>
        
        <div class="test-item">
            <strong>OTP_EXPIRY_MINUTES:</strong> <?php echo OTP_EXPIRY_MINUTES; ?>
        </div>
        
        <?php if ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
            <h2>Sending Test Email</h2>
            <?php
                $email = trim($_POST['email'] ?? '');
                
                if (empty($email)) {
                    echo "<div class='test-item error'>❌ Email address required</div>";
                } else if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    echo "<div class='test-item error'>❌ Invalid email format</div>";
                } else {
                    $otpHandler = new OTPHandler($conn);
                    $otp = $otpHandler->generateOTP();
                    
                    echo "<div class='test-item'>Generated OTP: <strong>$otp</strong></div>";
                    
                    // Try to send email
                    $result = $otpHandler->sendOTPEmail($email, $otp, 'registration');
                    
                    if ($result) {
                        echo "<div class='test-item success'>✅ Email sent successfully!</div>";
                        echo "<div class='test-item'>Check your email at: <strong>$email</strong></div>";
                    } else {
                        echo "<div class='test-item error'>❌ Failed to send email</div>";
                        echo "<div class='test-item error'>Check PHP error log for details</div>";
                    }
                }
            ?>
        <?php endif; ?>
        
        <h2>Send Test Email</h2>
        <form method="POST">
            <input type="email" name="email" placeholder="Enter your email address" required>
            <button type="submit">Send Test Email</button>
        </form>
        
    </div>
</body>
</html>
